<?php /*Template Name: addcourse */
acf_form_head();
get_header();
global $wpdb, $current_user, $wp_roles;
$userId = get_current_user_id();

$user_instructor = get_field('user_membership', 'user_' . $current_user->ID) == 'instructor';
$user_member = get_field('user_membership', 'user_' . $current_user->ID) == 'member';
$user_status_activate = get_field('user_status', 'user_' . $current_user->ID) == 'activate';
$user_status_deactivate = get_field('user_status', 'user_' . $current_user->ID) == 'deactivate';
 if (!is_user_logged_in() || $user_member) {
    $home = esc_url(home_url(''));
    header("Location: $home");
    exit;
}
?>
<style>
    .attachments-browser
    .attachments,
    .attachments-browser .uploader-inline {
        position: absolute;
        top: 5px !important;
        right: 0;
        left: 0 !important;
        bottom: 0;
        overflow: auto;
        outline: 0;
        z-index: 999999999999999999;
        background: #fff;
    }

    .media-toolbar-secondary,
    a.acf-expand-details,
    span.screen-reader-text,
    h2.media-frame-actions-heading.screen-reader-text,
    span.setting.has-description,
    p#alt-text-description,
    span.setting,
    h2.media-frame-menu-heading {
        display: none !important;
    }

    .media-sidebar input[type="text"],
    .media-sidebar textarea,
    .media-sidebar span.name {
        display: none;
    }

    .media-sidebar {
        position: absolute;
        bottom: 0;
        width: 98%;
        max-width: 98% !important;
        right: 0;
        padding: 0 16px 24px;
        z-index: 75;
        border-right: 1px solid #ddd;
        overflow: auto;
        -webkit-overflow-scrolling: touch;
    }

    .acf-fields > .acf-field {
        padding: 0;
        margin-bottom: 15px;
        border-top: 0;
     }

    .acf-field input[type="text"] {
        padding: 10px;
        background-color: #eee;
    }

    .acf-button {
        background-color: var(--primary);
        color: #fff;
        padding: 8px 35px;
         display: table;
        transition: all 0.5s linear;
    }

    .acf-button:hover {
        background-color: var(--secondary);
        color: #fff;
    }

</style>
<section class="content">
    <div class="container">
        <h1 class="main-title text-center">
            <span class="main-tit text-center d-block">
                <?php the_title(); ?>
            </span>
        </h1>

        <?php if ($user_instructor && $user_status_activate): ?>
            <?php
            acf_form(array(
                'updated_message' => __('تم اضافة الدرس بنجاح.. جاري المراجعة من قبل الادارة', 'm7md'),
                'post_title' => true,
                'post_content' => true,
                'post_id' => 'new_post',
                'new_post' => array(
                    'post_type' => 'courses',
                    'post_status' => 'draft'
                ),
                'field_groups' => array(29),
                 'html_submit_button' => '<button type="submit" class="main-button"><span>'.__('اضافة الدرس', 'm7md').'</span>'.get_switch_language('<i class="fa-solid fa-arrow-left-long"></i>',
                                '<i class="fa-solid fa-arrow-right-long"></i>').'</button>',
            ));
            ?>

        <?php elseif ($user_instructor && $user_status_deactivate): ?>
            <div class="alert alert-primary alert-dismissible fade show" role="alert">
                <strong><?php _e('انت مسجل فى الموقع كمحاضر وفى انتظار تفعيل عضويتك', 'm7md') ?></strong>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

    </div>
</section>


<?php get_footer(); ?>
